	function [unique_roots, multiplicity] = UNIQUE_ROOTS(r, tol)
	 
	%	Finds the unique roots and their multiplicity for the roots in the vector r.
	%	Two roots are considered to be equal and multiplicity = 2 if both the real
	%	and imaginary parts are within the tolerance, tol.
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB, Springer, 2009
		
	%	Example
	%	r = [0.8+j*0.5 0.8-j*0.5 0.8+j*0.5 0.8-j*0.5 -1 1 1.00001];
	%	tol = 1e-8;
	%	[unique_roots, multiplicity] = organize_roots(r, tol), gives
	%	unique_roots = [0.8+j*0.5 0.8-j*0.5 -1 1 1.00001] and multiplicity = [2 2 1 1 1]	
	
	% 	Author: 		Per Loewenborg 2004-11-12
	% 	Modified by: 	LW 2004-11-13, 2005-05-03
	% 	Copyright:		Divison of Electronics Systems
	% 					Dept. Electrical Engineering, Linkoping University, Sweden
	% 	Version:		1 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
 
	if (nargin == 1), tol = 100*eps; end
	unique_roots = [];
	multiplicity = [];
	while ~isempty(r)
		k = find(and(abs(real(r)-real(r(1))) < tol, abs(imag(r)-imag(r(1))) < tol));
		unique_roots = [unique_roots r(1)];
		multiplicity = [multiplicity length(k)];
		r(k) = [];
	end
